import emerge as em
from emerge.plot import plot_sp


mm = 0.001

material = em.lib.DIEL_RO4350B
thickness = 0.508

w0 = 1.1

with em.Simulation('Example', load_file=True) as sim:


    data = sim.data.mw

    grid = data.scalar.grid

    fd = grid.dense_f(1001)
    
    plot_sp(fd, [grid.model_S(1,1), grid.model_S(2,1)], labels=['S11','S21'])