import emerge as em


mm = 0.001

material = em.lib.DIEL_RO4350B
thickness = 0.508

w0 = 1.1

with em.Simulation('Example') as sim:
    
    # You do not have to use physically thick traces
    pcb = em.geo.PCBNew(thickness, mm, material=material)

    pcb.new(0,0, w0, (1,0))['p1'].straight(10)['p2']
    
    trace = pcb.compile_paths(True)
    
    pcb.determine_bounds(4,4,4,4)
    
    diel = pcb.generate_pcb()
    air = pcb.generate_air(5)
    
    lp1 = pcb.lumped_port('p1')
    lp2 = pcb.lumped_port('p2')
    
    sim.commit_geometry()
    
    sim.mw.set_frequency_range(0.5e9, 5e9, 41)
    
    sim.mw.set_resolution(0.2)
    sim.mesher.set_boundary_size(trace, 0.5*mm)
    
    sim.generate_mesh()
    
    sim.mw.bc.LumpedPort(lp1, 1)
    sim.mw.bc.LumpedPort(lp2, 2)
    
    sim.view()
    
    data = sim.mw.run_sweep()
    
    sim.save()
    